/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.BaseModel;
import io.github.foundationgames.automobility.automobile.render.ExhaustFumesModel;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.automobile.render.SkidEffectModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.FrontAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.RearAttachmentRenderModel;
import io.github.foundationgames.automobility.util.AUtils;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class AutomobileRenderer
extends Enum<AutomobileRenderer> {
    private static final /* synthetic */ AutomobileRenderer[] $VALUES;

    public static AutomobileRenderer[] values() {
        return (AutomobileRenderer[])$VALUES.clone();
    }

    public static AutomobileRenderer valueOf(String name) {
        return Enum.valueOf(AutomobileRenderer.class, name);
    }

    public static void render(PoseStack pose, MultiBufferSource buffers, int light, int overlay, float tickDelta, RenderableAutomobile automobile) {
        FrontAttachmentType<?> frontAtt;
        RearAttachmentType<?> rearAtt;
        AutomobileFrame frame = automobile.getFrame();
        AutomobileWheel wheels = automobile.getWheels();
        AutomobileEngine engine = automobile.getEngine();
        Model skidEffectModel = AutomobileModels.getSkidEffectModel();
        Model exhaustFumesModel = AutomobileModels.getExhaustFumesModel();
        pose.pushPose();
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        pose.mulPose(Axis.YP.rotationDegrees(automobile.getAutomobileYaw(tickDelta) + 180.0f));
        float chassisRaise = wheels.model().radius() / 16.0f;
        float bounce = automobile.getSuspensionBounce(tickDelta) * 0.048f;
        Model frameModel = AutomobileModels.getModel(automobile.getFrame().model().modelId());
        Model wheelModel = AutomobileModels.getModel(automobile.getWheels().model().modelId());
        Model engineModel = AutomobileModels.getModel(automobile.getEngine().model().modelId());
        Model rearAttachmentModel = AutomobileModels.getModel(automobile.getRearAttachmentType().model().modelId());
        Model frontAttachmentModel = AutomobileModels.getModel(automobile.getFrontAttachmentType().model().modelId());
        pose.translate(0.0f, -chassisRaise, 0.0f);
        pose.pushPose();
        pose.translate(0.0, (double)bounce + (automobile.engineRunning() ? Math.cos((double)((float)automobile.getTime() + tickDelta) * 2.7) / 156.0 : 0.0), 0.0);
        ResourceLocation frameTexture = frame.model().texture();
        ResourceLocation engineTexture = engine.model().texture();
        if (!frame.isEmpty() && frameModel != null) {
            frameModel.renderToBuffer(pose, buffers.getBuffer(frameModel.renderType(frameTexture)), light, overlay, -1);
            if (frameModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frameModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        Vec3 ePos = frame.model().enginePos().scale(0.0625);
        pose.translate(ePos.x(), -ePos.y(), -ePos.z());
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        if (!engine.isEmpty() && engineModel != null) {
            engineModel.renderToBuffer(pose, buffers.getBuffer(engineModel.renderType(engineTexture)), light, overlay, -1);
            if (engineModel instanceof BaseModel) {
                BaseModel base = (BaseModel)engineModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        VertexConsumer exhaustBuffer = null;
        if (automobile.getBoostTimer() > 0) {
            exhaustTexes = ExhaustFumesModel.FLAME_TEXTURES;
            index = (int)(automobile.getTime() % (long)exhaustTexes.length);
            exhaustBuffer = buffers.getBuffer(RenderType.eyes((ResourceLocation)exhaustTexes[index]));
        } else if (automobile.engineRunning()) {
            exhaustTexes = ExhaustFumesModel.SMOKE_TEXTURES;
            index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)exhaustTexes.length);
            exhaustBuffer = buffers.getBuffer(RenderType.entityTranslucent((ResourceLocation)exhaustTexes[index]));
        }
        if (exhaustBuffer != null) {
            for (AutomobileEngine.ExhaustPos exhaust : engine.model().exhausts()) {
                pose.pushPose();
                pose.translate(exhaust.x() / 16.0f, -exhaust.y() / 16.0f, exhaust.z() / 16.0f);
                pose.mulPose(Axis.YP.rotationDegrees(exhaust.yaw()));
                pose.mulPose(Axis.XP.rotationDegrees(exhaust.pitch()));
                exhaustFumesModel.renderToBuffer(pose, exhaustBuffer, light, overlay, -1);
                pose.popPose();
            }
        }
        pose.popPose();
        List<WheelBase.WheelPos> wPoses = frame.model().wheelBase().wheels();
        if (!wheels.isEmpty() && wheelModel != null) {
            VertexConsumer wheelBuffer = buffers.getBuffer(wheelModel.renderType(wheels.model().texture()));
            float wheelAngle = automobile.getWheelAngle(tickDelta);
            int wheelCount = automobile.getWheelCount();
            for (WheelBase.WheelPos pos : wPoses) {
                if (wheelCount <= 0) break;
                float scale = pos.scale();
                float wheelRadius = wheels.model().radius() - wheels.model().radius() * (scale - 1.0f);
                pose.pushPose();
                pose.translate(pos.right() / 16.0f, wheelRadius / 16.0f, -pos.forward() / 16.0f);
                if (pos.end() == WheelBase.WheelEnd.FRONT) {
                    pose.mulPose(Axis.YP.rotationDegrees(automobile.getSteering(tickDelta) * 27.0f));
                }
                pose.translate(0.0f, -chassisRaise, 0.0f);
                pose.mulPose(Axis.XP.rotationDegrees(wheelAngle));
                pose.scale(scale, scale, scale);
                pose.mulPose(Axis.YP.rotationDegrees(180.0f + pos.yaw()));
                wheelModel.renderToBuffer(pose, wheelBuffer, light, overlay, -1);
                if (wheelModel instanceof BaseModel) {
                    BaseModel base = (BaseModel)wheelModel;
                    base.doOtherLayerRender(pose, buffers, light, overlay);
                }
                pose.popPose();
                --wheelCount;
            }
        }
        if (!(rearAtt = automobile.getRearAttachmentType()).isEmpty() && rearAttachmentModel != null) {
            pose.pushPose();
            pose.translate(0.0f, chassisRaise, frame.model().rearAttachmentPos() / 16.0f);
            pose.mulPose(Axis.YN.rotationDegrees(automobile.getAutomobileYaw(tickDelta) - automobile.getRearAttachmentYaw(tickDelta)));
            pose.translate(0.0f, 0.0f, rearAtt.model().pivotDistPx() / 16.0f);
            if (rearAttachmentModel instanceof RearAttachmentRenderModel) {
                RearAttachmentRenderModel rm = (RearAttachmentRenderModel)rearAttachmentModel;
                rm.setRenderState(automobile.getRearAttachment(), (float)Math.toRadians(automobile.getWheelAngle(tickDelta)), tickDelta);
            }
            rearAttachmentModel.renderToBuffer(pose, buffers.getBuffer(rearAttachmentModel.renderType(rearAtt.model().texture())), light, overlay, -1);
            if (rearAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)rearAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.popPose();
        }
        if (!(frontAtt = automobile.getFrontAttachmentType()).isEmpty() && frontAttachmentModel != null) {
            pose.pushPose();
            pose.translate(0.0f, 0.0f, frame.model().frontAttachmentPos() / -16.0f);
            if (frontAttachmentModel instanceof FrontAttachmentRenderModel) {
                FrontAttachmentRenderModel fm = (FrontAttachmentRenderModel)frontAttachmentModel;
                fm.setRenderState(automobile.getFrontAttachment(), chassisRaise, tickDelta);
            }
            frontAttachmentModel.renderToBuffer(pose, buffers.getBuffer(frontAttachmentModel.renderType(frontAtt.model().texture())), light, overlay, -1);
            if (frontAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frontAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.popPose();
        }
        if ((automobile.getTurboCharge() > 35 || automobile.debris()) && automobile.automobileOnGround()) {
            ResourceLocation[] skidTexes = SkidEffectModel.COOL_SPARK_TEXTURES;
            boolean bright = true;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (automobile.getTurboCharge() > 115) {
                skidTexes = SkidEffectModel.FLAME_TEXTURES;
            } else if (automobile.getTurboCharge() > 70) {
                skidTexes = SkidEffectModel.HOT_SPARK_TEXTURES;
            } else if (automobile.debris()) {
                skidTexes = SkidEffectModel.DEBRIS_TEXTURES;
                Vector3f c = automobile.debrisColor();
                r = c.x() * 0.85f;
                g = c.y() * 0.85f;
                b = c.z() * 0.85f;
                bright = false;
            }
            int index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)skidTexes.length);
            VertexConsumer skidEffectBuffer = buffers.getBuffer(bright ? RenderType.eyes((ResourceLocation)skidTexes[index]) : RenderType.entitySmoothCutout((ResourceLocation)skidTexes[index]));
            for (WheelBase.WheelPos pos : wPoses) {
                if (pos.end() != WheelBase.WheelEnd.BACK) continue;
                float scale = pos.scale();
                float heightOffset = wheels.model().radius();
                float wheelRadius = wheels.model().radius() * scale;
                float wheelWidth = wheels.model().width() / 16.0f * scale;
                float back = wheelRadius > 2.0f ? (float)(Math.sqrt((double)(wheelRadius * wheelRadius) - Math.pow(wheelRadius - 2.0f, 2.0)) - 0.85) / 16.0f : 0.08f;
                pose.pushPose();
                pose.translate(pos.right() / 16.0f + wheelWidth * (float)(pos.side() == WheelBase.WheelSide.RIGHT ? 1 : -1), heightOffset / 16.0f, -pos.forward() / 16.0f + back);
                pose.scale(pos.side() == WheelBase.WheelSide.LEFT ? -1.0f : 1.0f, 1.0f, -1.0f);
                skidEffectModel.renderToBuffer(pose, skidEffectBuffer, light, overlay, AUtils.colorToInt(0.6f, r, g, b));
                pose.popPose();
            }
        }
        pose.popPose();
    }

    private static /* synthetic */ AutomobileRenderer[] $values() {
        return new AutomobileRenderer[0];
    }

    static {
        $VALUES = AutomobileRenderer.$values();
    }
}

